<?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/idnex.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    //COMPONENTI DELLE PAGINE

// funzione che stampa l'immagine laterale, che si può impostare tramite il componente 
    // immagine laterale
    function stampaImmagine($impostazioni,$dati,$stampaSezione = "si") {
        $codiceImmagineSfondo = "";
        $codiceAnimazione = ($dati["animazione"]!="") ? "data-aos=\"{$dati["animazione"]}\"" : "";
        
        // codice valido solo fino a quando il c'è un campo
        $arrayOpzioni = explode("=",$dati["altreOpzioni"]);
        if(isset($arrayOpzioni[1])) {
            $spazioOccupato = str_replace(";","",$arrayOpzioni[1]);
        }
        else {
            $spazioOccupato = "";
        }
            
        $codiceTesto = "<div class=\"$spazioOccupato\" $codiceAnimazione>
                <img class=\"img-fluid\" src=\"{$impostazioni["urlPiattaforma"]}/{$dati["testo"]}\" >
            </div>";
                
        if($stampaSezione=="si") {
            
            $idSezione         = "";
            $classeSezione     = "class=\"{$dati["classeSezione"]}\"";
            $codiceColore      = "";
            $codiceAnimazione  = "";
            $codiceVideoSfondo = "";
        
            if($dati["idSezione"]!="") {
                $idSezione = "id=\"{$dati["idSezione"]}\"";
            }

            $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "container-fluid" : "container";

            if($dati["coloreSfondo"]!="") {
                $codiceColore = "style=\"background-color:{$dati["coloreSfondo"]};\"";
            }
        
            if($dati["immagineSfondo"]!="") {
                $codiceImmagineSfondo = "style=\"background-image:url({$dati["immagineSfondo"]});\"";

                $classeSezione = "class=\"{$dati["classeSezione"]} background-image\"";
            }

            if($dati["videoSfondo"]!="") {
                $arrayVideo           = explode(".",$dati["videoSfondo"]);
                $estensioneVideo      = $arrayVideo[1];
                $stringaPoster        = ($dati["immagineSfondo"]!="") ? "poster: {$dati["immagineSfondo"]}" : "";
                $codiceVideoSfondo    = "data-vide-bg=\"$estensioneVideo: {$dati["videoSfondo"]}, $stringaPoster\" data-vide-options=\"loop: true, muted: true, position: 50% 50%\"";
                $codiceImmagineSfondo = "";
            }
        
            echo"<section  $idSezione $classeSezione $codiceColore $codiceImmagineSfondo $codiceVideoSfondo>
                    <div class=\"$classeContainer\">
                        <div class=\"row\">
                            $codiceTesto
                        </div>
                    </div>
                </section>";
        }
        else {
            echo "$codiceTesto";
        }
    }

    // funzione che stampa un codice html personalizzato nella colonna laterale, 
    // queste voci si possono impostare in amministrazione nella sezione componenti
    function stampaCodiceHtml($dati,$stampaSezione = "si") {
        $idSezione     = "";
        $classeSezione = "";
        $codiceColore  = "";
        $codiceImmagineSfondo = "";
        $codiceVideoSfondo    = "";
                
        if($dati["idSezione"]!="") {
            $idSezione = "id=\"{$dati["idSezione"]}\"";
        } 
        if($dati["classeSezione"]!="") {
            $classeSezione = "class=\"{$dati["classeSezione"]}\"";
        }
        
        $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "container-fluid" : "container";
                
        if($dati["coloreSfondo"]!="") {
            $codiceColore = "style=\"background-color:{$dati["coloreSfondo"]};\"";
        }
            
        if($dati["immagineSfondo"]!="") {
            $codiceImmagineSfondo = "style=\"background-image:url({$dati["immagineSfondo"]});\"";

            $classeSezione = "class=\"{$dati["classeSezione"]} background-image\"";
        }
            
        if($dati["videoSfondo"]!="") {
            $arrayVideo           = explode(".",$dati["videoSfondo"]);
            $estensioneVideo      = $arrayVideo[1];
            $stringaPoster        = ($dati["immagineSfondo"]!="") ? "poster: {$dati["immagineSfondo"]}" : "";
            $codiceVideoSfondo    = "data-vide-bg=\"$estensioneVideo: {$dati["videoSfondo"]}, $stringaPoster\" data-vide-options=\"loop: true, muted: true, position: 50% 50%\"";
            $codiceImmagineSfondo = "";
        }
        
        if($stampaSezione=="si") {
            echo"<section  $idSezione $classeSezione $codiceColore $codiceImmagineSfondo $codiceVideoSfondo>
                <div class=\"$classeContainer\">
                    {$dati["testo"]}
                </div>
            </section>";
        }
        else {
            echo $dati["testo"];
        }
    }

    // funzione che stampa un testo personalizzato nella pagina
    // viene effettuato il replace del percorso delle immagini, perché
    // lato utente devono essere inserite senza "../" (riga 76 di questo file)
    function stampaTesto($dati,$stampaSezione = "si") {

        $idSezione = "";
        $classeSezione    = "";
        $codiceAnimazione = "";
        $codiceColore     = "";
        $codiceImmagineSfondo = "";
        $codiceVideoSfondo    = "";
                
        if($dati["idSezione"]!="") {
            $idSezione = "id=\"{$dati["idSezione"]}\"";
        }
        
        if($dati["classeSezione"]!="") {
            $classeSezione = "class=\"{$dati["classeSezione"]}\"";
        }
        
        if($dati["animazione"]!="") {
            $codiceAnimazione = "data-aos=\"{$dati["animazione"]}\"";
        }
        
        if($dati["coloreSfondo"]!="") {
            $codiceColore = "style=\"background-color:{$dati["coloreSfondo"]};\"";
        }
        
        if($dati["immagineSfondo"]!="") {
            $codiceImmagineSfondo = "style=\"background-image:url({$dati["immagineSfondo"]});\"";

            $classeSezione = "class=\"{$dati["classeSezione"]} background-image\"";
        }
        
        if($dati["videoSfondo"]!="") {
            $arrayVideo           = explode(".",$dati["videoSfondo"]);
            $estensioneVideo      = $arrayVideo[1];
            $stringaPoster        = ($dati["immagineSfondo"]!="") ? "poster: {$dati["immagineSfondo"]}" : "";
            $codiceVideoSfondo    = "data-vide-bg=\"$estensioneVideo: {$dati["videoSfondo"]}, $stringaPoster\" data-vide-options=\"loop: true, muted: true, position: 50% 50%\"";
            $codiceImmagineSfondo = "";
        }
        
        // codice valido solo fino a quando il c'è un campo
        $arrayOpzioni = explode("=",$dati["altreOpzioni"]);
        if(isset($arrayOpzioni[1])) {
            $spazioOccupato = str_replace(";","",$arrayOpzioni[1]);
        }
        else {
            $spazioOccupato = "";
        }
                  
        $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "container-fluid" : "container";
        
        $testo = str_replace("../immagini/","immagini/",$dati["testo"]);
        
        if($stampaSezione=="si") {
            echo "<section $idSezione $classeSezione $codiceColore $codiceImmagineSfondo $codiceVideoSfondo>
                    <div class=\"$classeContainer\">
                        <div class=\"row\">
                            <div class=\"$spazioOccupato\" $codiceAnimazione>$testo</div>
                        </div>
                    </div>
                </section>";
        }
        else {
            echo "<div class=\"$spazioOccupato\" $codiceAnimazione>$testo</div>";
        }
    }
    
    // funzione che stampa una sezione con un carattere h
    // viene effettuato il replace del percorso delle immagini, perché
    // lato utente devono essere inserite senza "../"
    function stampaIntestazione($dati,$stampaSezione="si") {
        $idSezione            = "";
        $classeSezione        = "class=\"intestazione {$dati["classeSezione"]}\"";
        $codiceAnimazione     = "";
        $codiceColore         = "";
        $codiceImmagineSfondo = "";
        $codiceVideoSfondo    = "";
        
        if($dati["idSezione"]!="") {
            $idSezione = "id=\"{$dati["idSezione"]}\"";
        }
        
        if($dati["animazione"]!="") {
            $codiceAnimazione = "data-aos=\"{$dati["animazione"]}\"";
        }
        
        // recupero le opzioni supplementari inserite nella colonna "altreOpzioni", se il campo
        // altre opzioni è vuoto questi dati vengono inizializzati con una stringa vuota
        
        if($dati["altreOpzioni"]!="") {
            $arrayOpzioni = explode(";",$dati["altreOpzioni"]);
            $arrayOpzioneSpazioOccupato = explode("=",$arrayOpzioni[0]);
            if(isset($arrayOpzioni[1])) {
                $spazioOccupato = str_replace(";","",$arrayOpzioneSpazioOccupato[1]);
            }
            else {
                $spazioOccupato = "";
            }

            $arrayIntestazioneScelta = explode("=",$arrayOpzioni[1]);
            if(isset($arrayOpzioni[1])) {
                $intestazioneH = str_replace(";","",$arrayIntestazioneScelta[1]);
            }
            else {
                $intestazioneH = "h1";
            }
            
            $arrayOpzioneSeparatore = explode("=",$arrayOpzioni[2]);
            $opzioneSeparatore = str_replace(";","",$arrayOpzioneSeparatore[1]);
            if($opzioneSeparatore=="Sotto") {
                $classeSeparatore = "separatore-inferiore";
            }
            else if ($opzioneSeparatore=="Sopra") {
                $classeSeparatore = "separatore-superiore";
            }
            else {
                $classeSeparatore = "";
            }

            $arrayAllineamentoScelto = explode("=",$arrayOpzioni[3]);
            if(isset($arrayOpzioni[1])) {
                $allineamento = str_replace(";","",$arrayAllineamentoScelto[1]);
            }
            else {
                $allineamento = "";
            }
        }
        else {
            $spazioOccupato = "";
            $intestazioneH  = "";
            $classeSeparatore = "";
            $allineamento = "";
        }
        
        if($dati["coloreSfondo"]!="") {
            $codiceColore = "style=\"background-color:{$dati["coloreSfondo"]};\"";
        }
        
        if($dati["immagineSfondo"]!="") {
            $codiceImmagineSfondo = "style=\"background-image:url({$dati["immagineSfondo"]});\"";

            $classeSezione = "class=\"intestazione {$dati["classeSezione"]} background-image\"";
        }
        
        if($dati["videoSfondo"]!="") {
            $arrayVideo           = explode(".",$dati["videoSfondo"]);
            $estensioneVideo      = $arrayVideo[1];
            $stringaPoster        = ($dati["immagineSfondo"]!="") ? "poster: {$dati["immagineSfondo"]}" : "";
            $codiceVideoSfondo    = "data-vide-bg=\"$estensioneVideo: {$dati["videoSfondo"]}, $stringaPoster\" data-vide-options=\"loop: true, muted: true, position: 50% 50%\"";
            $codiceImmagineSfondo = "";
        }
        
        $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "container-fluid" : "container";
        
        if($stampaSezione=="si") {
            echo "<section $idSezione $classeSezione $codiceColore $codiceImmagineSfondo $codiceVideoSfondo>
                    <div class=\"$classeContainer\">
                        <div class=\"row\">
                            <div class=\"$spazioOccupato\" $codiceAnimazione>";
                                if($dati["testo"]!="") {
                                    echo"<$intestazioneH class=\"$classeSeparatore $allineamento\">{$dati["testo"]}</$intestazioneH>";
                                }
                            echo"</div>
                        </div>
                    </div>
                </section>";
        }
        else {
            
            echo"<div class=\"$spazioOccupato\">";
                if($dati["testo"]!="") {
                    echo"<$intestazioneH class=\"$classeSeparatore $allineamento\" $codiceAnimazione>{$dati["testo"]}</$intestazioneH>";
                }
            echo"</div>";
        }
    }
    
    // funzione che stampa una sezione con il tag audio
    function stampaAudio($dati) {
        $idSezione = "";
        $classeSezione    = "";
        $codiceAnimazione = "";
        $codiceColore         = "";
        $codiceImmagineSfondo = ""; 
        $codiceVideoSfondo    = "";
        
        if($dati["idSezione"]!="") {
            $idSezione = "id=\"{$dati["idSezione"]}\"";
        }
        
        if($dati["classeSezione"]!="") {
            $classeSezione = "class=\"{$dati["classeSezione"]}\"";
        }
        
        if($dati["coloreSfondo"]!="") {
            $codiceColore = "style=\"background-color:{$dati["coloreSfondo"]};\"";
        }
        
        if($dati["animazione"]!="") {
            $codiceAnimazione = "data-aos=\"{$dati["animazione"]}\"";
        }
        
        if($dati["immagineSfondo"]!="") {
            $codiceImmagineSfondo = "style=\"background-image:url({$dati["immagineSfondo"]});\"";

            $classeSezione = "class=\"{$dati["classeSezione"]} background-image\"";
        }
        
        if($dati["videoSfondo"]!="") {
            $arrayVideo           = explode(".",$dati["videoSfondo"]);
            $estensioneVideo      = $arrayVideo[1];
            $stringaPoster        = ($dati["immagineSfondo"]!="") ? "poster: {$dati["immagineSfondo"]}" : "";
            $codiceVideoSfondo    = "data-vide-bg=\"$estensioneVideo: {$dati["videoSfondo"]}, $stringaPoster\" data-vide-options=\"loop: true, muted: true, position: 50% 50%\"";
            $codiceImmagineSfondo = "";
        }
        
        // recupero le opzioni supplementari inserite nella colonna "altreOpzioni"
        $arrayOpzioni = explode(";",$dati["altreOpzioni"]);
        $arrayOpzioneSpazioOccupato = explode("=",$arrayOpzioni[0]);
        if(isset($arrayOpzioni[1])) {
            $spazioOccupato = str_replace(";","",$arrayOpzioneSpazioOccupato[1]);
        }
        else {
            $spazioOccupato = "";
        }
        
        $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "container-fluid" : "container";
        echo "<section $idSezione $classeSezione $codiceColore  $codiceImmagineSfondo $codiceVideoSfondo>
                <div class=\"$classeContainer\">
                    <div class=\"row\">
                        <div class=\"$spazioOccupato\" $codiceAnimazione>"
                            ."<audio class=\"w-100\" controls>
                                <source src=\"{$dati["testo"]}\" type=\"audio/mpeg\">
                                Il tuo browser non supporta l'lemento audio.
                            </audio>
                         </div>
                    </div>
                </div>
            </section>";
    }
    
    // funzione che stampa un testo personalizzato nella colonna laterale, 
    function includiCodice($dati) {
        include "template/include/fileInlcusione/".$dati["testo"];
    }